function pdf = WB_density(xval,Ft,k)
%==========================================================================================
% This function computes the pdf of the Weibull distribution with parameters
% Ft and k at xval
%==========================================================================================
%INPUT:
%   xval: points to evaluate the pdf of the Weibull density, must be a column vector
%   Ft: mean of Weibull density
%   k: scale parameter of Weibull density (see Eq. (6) of Li, Nolte and Pham (2023))
%
%OUTPUT:
%   pdf: pdf evaluated at xval
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 

sx = (xval.*gamma(1+k)./Ft).^(1./k);
pdf = exp(-sx).*sx./k./xval;

end

